/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.config;

import br.com.apifibra.fibrafisio.filter.JwtAuthenticationFilter;
import br.com.apifibra.fibrafisio.filter.JwtAuthorizationFilter;
import br.com.apifibra.fibrafisio.service.UserDetailsServiceImpl;
import br.com.apifibra.fibrafisio.util.JwtUtil;
import jakarta.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.userdetails.DaoAuthenticationConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
public class SecurityConfig {
    private final UserDetailsServiceImpl userDetailsService;

    public SecurityConfig(UserDetailsServiceImpl userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    @Bean
    public JwtUtil jwtUtil() {
        return new JwtUtil();
    }

    @Bean
    public AuthenticationManager authenticationManager(HttpSecurity http, PasswordEncoder passwordEncoder) throws Exception {
        return (AuthenticationManager)((AuthenticationManagerBuilder)((DaoAuthenticationConfigurer)((AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class)).userDetailsService((UserDetailsService)this.userDetailsService).passwordEncoder(passwordEncoder)).and()).build();
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        JwtUtil jwtUtil = this.jwtUtil();
        http.csrf(csrf -> csrf.disable()).sessionManagement(management -> management.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authorizeHttpRequests(requests -> {
            try {
                ((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new String[]{"/auth/login", "/administradores", "/whatsapp/updateStatus", "/pacientes"})).permitAll().anyRequest()).authenticated().and()).addFilter((Filter)new JwtAuthenticationFilter(this.authenticationManager(http, this.passwordEncoder()), jwtUtil)).addFilter((Filter)new JwtAuthorizationFilter(this.authenticationManager(http, this.passwordEncoder()), jwtUtil, this.userDetailsService));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }
}

