/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.controller;

import br.com.apifibra.fibrafisio.dto.AdministradorDTO;
import br.com.apifibra.fibrafisio.model.Administrador;
import br.com.apifibra.fibrafisio.model.Profissional;
import br.com.apifibra.fibrafisio.service.AdministradorService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/administradores"})
public class AdministradorController {
    @Autowired
    private AdministradorService administradorService;

    @PostMapping
    public ResponseEntity<Administrador> createAdministrador(@RequestBody AdministradorDTO administradorDTO) {
        Administrador novoAdministrador = this.administradorService.save(administradorDTO);
        return ResponseEntity.ok((Object)novoAdministrador);
    }

    @GetMapping
    public List<Administrador> getAllAdministradores() {
        return this.administradorService.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Administrador> getAdministradorById(@PathVariable Long id) {
        Optional administrador = this.administradorService.findById(id);
        return administrador.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Administrador> updateAdministrador(@PathVariable Long id, @RequestBody AdministradorDTO administradorDTO) {
        Optional administrador = this.administradorService.findById(id);
        if (administrador.isPresent()) {
            Administrador updatedAdministrador = (Administrador)administrador.get();
            updatedAdministrador.setNome(administradorDTO.getNome());
            if (!administradorDTO.getSenha().isEmpty()) {
                updatedAdministrador.setSenha(this.administradorService.encodePassword(administradorDTO.getSenha()));
            }
            updatedAdministrador.setMaster(administradorDTO.isMaster());
            updatedAdministrador.setDescricao(administradorDTO.getDescricao());
            return ResponseEntity.ok((Object)this.administradorService.save(updatedAdministrador));
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteAdministrador(@PathVariable Long id) {
        if (this.administradorService.findById(id).isPresent()) {
            this.administradorService.deleteById(id);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/me/profissionais"})
    public ResponseEntity<List<Profissional>> getProfissionaisDoAdministrador() {
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        Optional administrador = this.administradorService.findByNome(username);
        if (administrador.isPresent()) {
            List profissionais = ((Administrador)administrador.get()).getProfissionais();
            return ResponseEntity.ok((Object)profissionais);
        }
        return ResponseEntity.status((int)403).build();
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<Administrador> getAdministradorLogado() {
        String username = SecurityContextHolder.getContext().getAuthentication().getName();
        Optional administrador = this.administradorService.findByNome(username);
        if (administrador.isPresent()) {
            return ResponseEntity.ok((Object)((Administrador)administrador.get()));
        }
        return ResponseEntity.status((int)403).build();
    }
}

