/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.controller;

import br.com.apifibra.fibrafisio.model.Endereco;
import br.com.apifibra.fibrafisio.service.EnderecoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enderecos"})
public class EnderecoController {
    @Autowired
    private EnderecoService enderecoService;

    @GetMapping
    public List<Endereco> getAllEnderecos() {
        return this.enderecoService.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Endereco> getEnderecoById(@PathVariable Long id) {
        Optional endereco = this.enderecoService.findById(id);
        return endereco.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public Endereco createEndereco(@RequestBody Endereco endereco) {
        return this.enderecoService.save(endereco);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Endereco> updateEndereco(@PathVariable Long id, @RequestBody Endereco enderecoDetails) {
        Optional endereco = this.enderecoService.findById(id);
        if (endereco.isPresent()) {
            Endereco updatedEndereco = (Endereco)endereco.get();
            updatedEndereco.setCep(enderecoDetails.getCep());
            updatedEndereco.setRua(enderecoDetails.getRua());
            updatedEndereco.setBairro(enderecoDetails.getBairro());
            updatedEndereco.setComplemento(enderecoDetails.getComplemento());
            updatedEndereco.setCidade(enderecoDetails.getCidade());
            updatedEndereco.setEstado(enderecoDetails.getEstado());
            return ResponseEntity.ok((Object)this.enderecoService.save(updatedEndereco));
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteEndereco(@PathVariable Long id) {
        if (this.enderecoService.findById(id).isPresent()) {
            this.enderecoService.deleteById(id);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }
}

