/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.controller;

import br.com.apifibra.fibrafisio.model.Evolucao;
import br.com.apifibra.fibrafisio.service.EvolucaoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/evolucoes"})
public class EvolucaoController {
    @Autowired
    private EvolucaoService evolucaoService;

    @GetMapping
    public List<Evolucao> getAllEvolucoes() {
        return this.evolucaoService.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Evolucao> getEvolucaoById(@PathVariable Long id) {
        Optional evolucao = this.evolucaoService.findById(id);
        return evolucao.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public Evolucao createEvolucao(@RequestBody Evolucao evolucao) {
        return this.evolucaoService.save(evolucao);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Evolucao> updateEvolucao(@PathVariable Long id, @RequestBody Evolucao evolucaoDetails) {
        Optional evolucao = this.evolucaoService.findById(id);
        if (evolucao.isPresent()) {
            Evolucao updatedEvolucao = (Evolucao)evolucao.get();
            updatedEvolucao.setDescricao(evolucaoDetails.getDescricao());
            updatedEvolucao.setProcedimento(evolucaoDetails.getProcedimento());
            updatedEvolucao.setAgendas(evolucaoDetails.getAgendas());
            return ResponseEntity.ok((Object)this.evolucaoService.save(updatedEvolucao));
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteEvolucao(@PathVariable Long id) {
        if (this.evolucaoService.findById(id).isPresent()) {
            this.evolucaoService.deleteById(id);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/agenda/{agendaId}"})
    public List<Evolucao> getEvolucoesByAgendaId(@PathVariable Long agendaId) {
        return this.evolucaoService.findByAgendaId(agendaId);
    }

    @GetMapping(value={"/procedimento/{procedimentoId}"})
    public List<Evolucao> getEvolucoesByProcedimentoId(@PathVariable Long procedimentoId) {
        return this.evolucaoService.findByProcedimentoId(procedimentoId);
    }
}

