/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.controller;

import br.com.apifibra.fibrafisio.model.FormaPagamento;
import br.com.apifibra.fibrafisio.service.FormaPagamentoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/forma-pagamentos"})
public class FormaPagamentoController {
    @Autowired
    private FormaPagamentoService formaPagamentoService;

    @GetMapping
    public List<FormaPagamento> getAllFormaPagamentos() {
        return this.formaPagamentoService.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<FormaPagamento> getFormaPagamentoById(@PathVariable Long id) {
        Optional formaPagamento = this.formaPagamentoService.findById(id);
        return formaPagamento.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public FormaPagamento createFormaPagamento(@RequestBody FormaPagamento formaPagamento) {
        return this.formaPagamentoService.save(formaPagamento);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<FormaPagamento> updateFormaPagamento(@PathVariable Long id, @RequestBody FormaPagamento formaPagamentoDetails) {
        Optional formaPagamento = this.formaPagamentoService.findById(id);
        if (formaPagamento.isPresent()) {
            FormaPagamento updatedFormaPagamento = (FormaPagamento)formaPagamento.get();
            updatedFormaPagamento.setDescricao(formaPagamentoDetails.getDescricao());
            return ResponseEntity.ok((Object)this.formaPagamentoService.save(updatedFormaPagamento));
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteFormaPagamento(@PathVariable Long id) {
        if (this.formaPagamentoService.findById(id).isPresent()) {
            this.formaPagamentoService.deleteById(id);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }
}

