/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.controller;

import br.com.apifibra.fibrafisio.model.Paciente;
import br.com.apifibra.fibrafisio.service.PacienteService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pacientes"})
public class PacienteController {
    @Autowired
    private PacienteService pacienteService;

    @GetMapping
    public List<Paciente> getAllPacientes() {
        return this.pacienteService.findAll();
    }

    @GetMapping(value={"/paginado"})
    public ResponseEntity<Page<Paciente>> getPacientes(@RequestParam int page, @RequestParam int size) {
        return ResponseEntity.ok((Object)this.pacienteService.getPacientesPaginados(page, size));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Paciente> getPacienteById(@PathVariable Long id) {
        Optional paciente = this.pacienteService.findById(id);
        return paciente.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public Paciente createPaciente(@RequestBody Paciente paciente) {
        return this.pacienteService.save(paciente);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Paciente> updatePaciente(@PathVariable Long id, @RequestBody Paciente pacienteDetails) {
        Optional paciente = this.pacienteService.findById(id);
        if (paciente.isPresent()) {
            Paciente updatedPaciente = (Paciente)paciente.get();
            updatedPaciente.setNome(pacienteDetails.getNome());
            updatedPaciente.setDataNascimento(pacienteDetails.getDataNascimento());
            updatedPaciente.setTelefone(pacienteDetails.getTelefone());
            updatedPaciente.setTelefone2(pacienteDetails.getTelefone2());
            updatedPaciente.setTelefone3(pacienteDetails.getTelefone3());
            updatedPaciente.setMatricula(pacienteDetails.getMatricula());
            updatedPaciente.setConvenio(pacienteDetails.getConvenio());
            updatedPaciente.setSexo(pacienteDetails.getSexo());
            updatedPaciente.setEtnia(pacienteDetails.getEtnia());
            updatedPaciente.setResponsaveis(pacienteDetails.getResponsaveis());
            updatedPaciente.setNomeMae(pacienteDetails.getNomeMae());
            updatedPaciente.setCpf(pacienteDetails.getCpf());
            updatedPaciente.setIdentidade(pacienteDetails.getIdentidade());
            updatedPaciente.setEmail(pacienteDetails.getEmail());
            updatedPaciente.setProfissao(pacienteDetails.getProfissao());
            updatedPaciente.setStatus(pacienteDetails.getStatus());
            updatedPaciente.setCodFibra(pacienteDetails.getCodFibra());
            updatedPaciente.setEndereco(pacienteDetails.getEndereco());
            return ResponseEntity.ok((Object)this.pacienteService.save(updatedPaciente));
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletePaciente(@PathVariable Long id) {
        if (this.pacienteService.findById(id).isPresent()) {
            this.pacienteService.deleteById(id);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/buscar/{letras}"})
    public ResponseEntity<List<Paciente>> buscarPacientesPorNome(@PathVariable String letras) {
        List pacientes = this.pacienteService.findByNomeContaining(letras);
        return new ResponseEntity((Object)pacientes, (HttpStatusCode)HttpStatus.OK);
    }
}

