/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.controller;

import br.com.apifibra.fibrafisio.model.Evolucao;
import br.com.apifibra.fibrafisio.model.Procedimento;
import br.com.apifibra.fibrafisio.service.EvolucaoService;
import br.com.apifibra.fibrafisio.service.ProcedimentoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/procedimentos"})
public class ProcedimentoController {
    @Autowired
    private ProcedimentoService procedimentoService;
    @Autowired
    private EvolucaoService evolucaoService;

    @GetMapping
    public List<Procedimento> getAllProcedimentos() {
        return this.procedimentoService.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Procedimento> getProcedimentoById(@PathVariable Long id) {
        Optional procedimento = this.procedimentoService.findById(id);
        return procedimento.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public Procedimento createProcedimento(@RequestBody Procedimento procedimento) {
        return this.procedimentoService.save(procedimento);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Procedimento> updateProcedimento(@PathVariable Long id, @RequestBody Procedimento procedimentoDetails) {
        Optional procedimento = this.procedimentoService.findById(id);
        if (procedimento.isPresent()) {
            Procedimento updatedProcedimento = (Procedimento)procedimento.get();
            updatedProcedimento.setDescricao(procedimentoDetails.getDescricao());
            updatedProcedimento.setCor(procedimentoDetails.getCor());
            updatedProcedimento.setValor(procedimentoDetails.getValor());
            return ResponseEntity.ok((Object)this.procedimentoService.save(updatedProcedimento));
        }
        return ResponseEntity.notFound().build();
    }

    @PutMapping(value={"/{procedimentoId}/evolucoes/{evolucaoId}"})
    public ResponseEntity<Procedimento> addEvolucaoToProcedimento(@PathVariable Long procedimentoId, @PathVariable Long evolucaoId) {
        Optional procedimentoOptional = this.procedimentoService.findById(procedimentoId);
        Optional evolucaoOptional = this.evolucaoService.findById(evolucaoId);
        if (procedimentoOptional.isPresent() && evolucaoOptional.isPresent()) {
            Procedimento procedimento = (Procedimento)procedimentoOptional.get();
            Evolucao evolucao = (Evolucao)evolucaoOptional.get();
            evolucao.setProcedimento(procedimento);
            procedimento.getEvolucoes().add(evolucao);
            this.procedimentoService.save(procedimento);
            this.evolucaoService.save(evolucao);
            return ResponseEntity.ok((Object)procedimento);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteProcedimento(@PathVariable Long id) {
        if (this.procedimentoService.findById(id).isPresent()) {
            this.procedimentoService.deleteById(id);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }
}

