/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.controller;

import br.com.apifibra.fibrafisio.model.Profissional;
import br.com.apifibra.fibrafisio.service.ProfissionalService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/profissionais"})
public class ProfissionalController {
    @Autowired
    private ProfissionalService profissionalService;

    @GetMapping
    public List<Profissional> getAllProfissionais() {
        return this.profissionalService.findAll();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Profissional> getProfissionalById(@PathVariable Long id) {
        Optional profissional = this.profissionalService.findById(id);
        return profissional.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public Profissional createProfissional(@RequestBody Profissional profissional) {
        return this.profissionalService.save(profissional);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Profissional> updateProfissional(@PathVariable Long id, @RequestBody Profissional profissionalDetails) {
        Optional profissional = this.profissionalService.findById(id);
        if (profissional.isPresent()) {
            Profissional updatedProfissional = (Profissional)profissional.get();
            updatedProfissional.setNome(profissionalDetails.getNome());
            return ResponseEntity.ok((Object)this.profissionalService.save(updatedProfissional));
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteProfissional(@PathVariable Long id) {
        if (this.profissionalService.findById(id).isPresent()) {
            this.profissionalService.deleteById(id);
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.notFound().build();
    }
}

