/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.filter;

import br.com.apifibra.fibrafisio.model.AuthRequest;
import br.com.apifibra.fibrafisio.util.JwtUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class JwtAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private final AuthenticationManager authenticationManager;
    private final JwtUtil jwtUtil;

    public JwtAuthenticationFilter(AuthenticationManager authenticationManager, JwtUtil jwtUtil) {
        this.authenticationManager = authenticationManager;
        this.jwtUtil = jwtUtil;
        this.setFilterProcessesUrl("/auth/login");
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        try {
            AuthRequest authRequest = (AuthRequest)new ObjectMapper().readValue((InputStream)request.getInputStream(), AuthRequest.class);
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)authRequest.getUsername(), (Object)authRequest.getPassword());
            return this.authenticationManager.authenticate((Authentication)authentication);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException {
        User user = (User)authResult.getPrincipal();
        String token = this.jwtUtil.generateToken(user.getUsername());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        tokenMap.put("token", token);
        new ObjectMapper().writeValue((Writer)response.getWriter(), tokenMap);
    }
}

