/*
 * Decompiled with CFR 0.152.
 */
package br.com.apifibra.fibrafisio.service;

import br.com.apifibra.fibrafisio.model.Agenda;
import br.com.apifibra.fibrafisio.repository.AgendaRepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@EnableScheduling
public class AgendaNotificationService {
    private static final Logger logger = LoggerFactory.getLogger(AgendaNotificationService.class);
    @Autowired
    private AgendaRepository agendaRepository;
    @PersistenceContext
    private EntityManager entityManager;
    private final String endpointUrl = "https://hook.us1.make.com/vdbbs3f4f936qlb7o42clbavxtxoopia";

    @Scheduled(cron="0 0/30 * * * ?")
    public void verificarAgendasParaNotificacao() {
        logger.info("Escala executada");
        LocalDateTime agora = LocalDateTime.now();
        LocalDateTime vinteQuatroHorasDepois = agora.plusHours(24L);
        LocalDate dataHoje = agora.toLocalDate();
        LocalDate dataAmanha = vinteQuatroHorasDepois.toLocalDate();
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
        String startHoje = agora.toLocalTime().format(timeFormatter);
        String endHoje = "23:59";
        String startAmanha = "00:00";
        String endAmanha = vinteQuatroHorasDepois.toLocalTime().format(timeFormatter);
        List agendasHoje = this.agendaRepository.findAgendasParaNotificacao(dataHoje, startHoje, endHoje, "AGENDADO");
        List agendasAmanha = this.agendaRepository.findAgendasParaNotificacao(dataAmanha, startAmanha, endAmanha, "AGENDADO");
        agendasHoje.addAll(agendasAmanha);
        agendasHoje.forEach(agenda -> {
            try {
                if (agenda.isNotificacao()) {
                    this.enviarNotificacaoAgenda(agenda).get();
                }
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                logger.error("Erro ao enviar notifica\u00e7\u00e3o para a agenda: " + agenda.getId(), (Throwable)e);
            }
        });
    }

    private CompletableFuture<Void> enviarNotificacaoAgenda(Agenda agenda) throws IOException {
        try {
            String telefoneFormatado = this.formatarTelefone(agenda.getPaciente().getTelefone());
            String dataFormatada = agenda.getData().format(DateTimeFormatter.ISO_LOCAL_DATE);
            String jsonBody = String.format("{\"id\": \"%d\", \"nome\": \"%s\", \"telefone\": \"%s\", \"data\": \"%s\", \"dataHora\": \"%s\"}", agenda.getId(), agenda.getPaciente().getNome(), telefoneFormatado, dataFormatada, agenda.getHorarioInicio());
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(new URI("https://hook.us1.make.com/vdbbs3f4f936qlb7o42clbavxtxoopia")).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(jsonBody)).build();
            return client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
                if (response.statusCode() == 200) {
                    logger.info("Notifica\u00e7\u00e3o enviada com sucesso para a agenda: " + agenda.getId());
                    agenda.setStatus("AGUARDANDO");
                    this.agendaRepository.save((Object)agenda);
                } else {
                    logger.warn("Falha ao enviar notifica\u00e7\u00e3o para a agenda: " + agenda.getId() + ". C\u00f3digo de resposta: " + response.statusCode());
                }
                return null;
            });
        }
        catch (URISyntaxException e) {
            logger.error("Erro ao enviar notifica\u00e7\u00e3o para a agenda: " + agenda.getId(), (Throwable)e);
            return CompletableFuture.completedFuture(null);
        }
    }

    private String formatarTelefone(String telefone) {
        Object telefoneFormatado = telefone.replaceAll("[^0-9]", "");
        if (((String)(telefoneFormatado = ((String)telefoneFormatado).replaceFirst("^0+(?!$)", ""))).startsWith("0")) {
            telefoneFormatado = "4" + (String)telefoneFormatado;
        }
        return telefoneFormatado;
    }
}

